/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.structure;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractStructureHandler
implements IStructureHandler {
    private Blueprint blueprint;
    private String md5;
    private PlacementSettings settings;
    private World world;
    private BlockPos worldPos;

    public AbstractStructureHandler(World world, BlockPos worldPos, String structureName, PlacementSettings settings) {
        this.world = world;
        this.worldPos = worldPos;
        this.settings = settings;
        this.loadBlueprint(structureName);
    }

    public AbstractStructureHandler(World world, BlockPos pos, Blueprint blueprint, PlacementSettings settings) {
        this.world = world;
        this.worldPos = pos;
        this.settings = settings;
        this.blueprint = blueprint;
    }

    @Override
    public boolean hasBluePrint() {
        return this.blueprint != null;
    }

    @Override
    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @Override
    public void setBlueprint(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    @Override
    public Blueprint getBluePrint() {
        return this.blueprint;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public String getMd5() {
        return this.md5;
    }

    @Override
    public BlockPos getWorldPos() {
        return this.worldPos;
    }

    @Override
    public PlacementSettings getSettings() {
        return this.settings;
    }
}

